<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="dak180(notes)"/>
	<xsl:output method="html" indent="no" encoding="ISO-8859-1"/>
	<xsl:template match="/character">
		<xsl:choose>
			<xsl:when test="count(/character[starts-with(etools-version, '1.6')])">
				<html>
					<head><title><xsl:value-of select="/character/name"/></title></head>
					<body>
						<xsl:call-template name="page-header">
							<xsl:with-param name="heading">FEATS / CLASS FEATURES</xsl:with-param>
						</xsl:call-template>
						<table><tr><td valign="top">
									<table>
										<xsl:if test="features/feats/feat">
											<tr><td style="border-bottom: 1pt solid black"><b>Feats:</b></td></tr>
											<tr><td>
													<font face="arial" style="font-size:8pt">
														<xsl:for-each select="features/feats/feat">
															<xsl:sort select="." order="ascending"/>
															<xsl:variable name="featname"><xsl:value-of select="name"/></xsl:variable>
															<xsl:choose>
																<xsl:when test="name = 'Armor Proficiency: heavy' and count(/character/features/class-features/class-feature[feature = 'Proficiency: Armor, Heavy'])"></xsl:when>
																<xsl:when test="name = 'Armor Proficiency: heavy' and count(/character/features/class-features/class-feature[feature = 'Heavy armor proficiency'])"></xsl:when>
																<xsl:when test="name = 'Armor Proficiency: medium' and count(/character/features/class-features/class-feature[feature = 'Medium armor proficiency'])"></xsl:when>
																<xsl:when test="name = 'Armor Proficiency: medium' and count(/character/features/class-features/class-feature[feature = 'Proficiency: Armor, Medium'])"></xsl:when>
																<xsl:when test="name = 'Armor Proficiency: light' and count(/character/features/class-features/class-feature[feature = 'Light armor proficiency'])"></xsl:when>
																<xsl:when test="name = 'Armor Proficiency: light' and count(/character/features/class-features/class-feature[feature = 'Proficiency: Armor, Light'])"></xsl:when>
																<xsl:when test="name = 'Shield Proficiency' and count(/character/features/class-features/class-feature[feature = 'Shield proficiency'])"></xsl:when>
																<xsl:when test="name = 'Shield Proficiency' and count(/character/features/class-features/class-feature[feature = 'Proficiency: Shields'])"></xsl:when>
																<xsl:when test="name = 'Simple Weapon Proficiency' and count(/character/features/class-features/class-feature[feature = 'Simple weapon proficiency'])"></xsl:when>
																<xsl:when test="name = 'Simple Weapon Proficiency' and count(/character/features/class-features/class-feature[feature = 'Proficiency: Simple Weapons: All'])"></xsl:when>
																<xsl:when test="starts-with(name, 'Martial Weapon Proficiency') and count(/character/features/class-features/class-feature[feature = 'Martial weapon proficiency: all'])"></xsl:when>
																<xsl:when test="starts-with(name, 'Martial Weapon Proficiency') and count(/character/features/class-features/class-feature[feature = 'Proficiency: Martial Weapons: All'])"></xsl:when>
																<xsl:when test="name = 'Tower Shield Proficiency' and count(/character/features/class-features/class-feature[feature = 'Proficiency: Tower Shield'])"></xsl:when>
																<xsl:otherwise>
																	<b><xsl:value-of select="name"/>: </b>
																	<xsl:value-of select="description"/><br/>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
													</font>
												</td></tr>
										</xsl:if>
										<tr><td style="border-bottom: 1pt solid black"><b>
													<xsl:if test="templates">
														<xsl:for-each select="templates/name">
															<xsl:variable name="template"><xsl:value-of select="."/></xsl:variable>
															<xsl:value-of select="."/>
															<xsl:text>
															</xsl:text>
														</xsl:for-each>
													</xsl:if>
													<xsl:value-of select="race"/> Racial Traits:
						</b></td></tr>
										<tr><td>
												<font face="arial" style="font-size:8pt">
													<xsl:if test="features/race-features/race-feature">
														<DL><tr><td><font face="arial" style="font-size:8pt">
																		<DT/><b><i><u>Special Features</u>:</i></b><br/>
																		<xsl:for-each select="features/race-features/race-feature">
																			<xsl:sort select="." order="ascending"/>
																			<xsl:variable name="racefeat"><xsl:value-of select="."/></xsl:variable>
																			<DD/><b><xsl:value-of select="."/></b><br/>
																		</xsl:for-each>
																	</font></td></tr></DL>
													</xsl:if>
													<xsl:if test="features/special-qualities/special-quality">
														<DL><tr><td><font face="arial" style="font-size:8pt">
																		<DT/><b><i><u>Special Qualities</u>:</i></b><br/>
																		<xsl:for-each select="features/special-qualities/special-quality">
																			<xsl:sort select="." order="ascending"/>
																			<xsl:variable name="special-quality"><xsl:value-of select="."/></xsl:variable>
																			<DD/><b><xsl:value-of select="."/></b><br/>
																		</xsl:for-each>
																	</font></td></tr></DL>
													</xsl:if>
													<xsl:if test="features/special-attacks/special-attack">
														<xsl:choose>
															<xsl:when test="features/special-attacks/special-attack/spell and 1=count(features/special-attacks/special-attack)"></xsl:when>
															<xsl:otherwise>
																<DL><tr><td><font face="arial" style="font-size:8pt">
																				<DT/><b><i><u>Special Atacks</u>:</i></b><br/>
																				<xsl:for-each select="features/special-attacks/special-attack">
																					<xsl:sort select="." order="ascending"/>
																					<xsl:variable name="name"><xsl:value-of select="."/></xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains($name, 'Spell-like Abilities')"></xsl:when>
																						<xsl:otherwise><DD/><b><xsl:value-of select="."/></b><br/></xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</font></td></tr></DL>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:if>
													<xsl:if test="features/special-attacks/special-attack/spell">
														<DL><tr><td><font face="arial" style="font-size:8pt">
																		<DT><b><i><u>Spell-like Abilities</u>:</i></b></DT><br/>
																		<xsl:for-each select="features/special-attacks/special-attack/spell">
																			<xsl:sort select="." order="ascending"/>
																			<xsl:variable name="name"><xsl:value-of select="name"/></xsl:variable>
																			<xsl:variable name="caster-level"><xsl:value-of select="caster-level"/></xsl:variable>
																			<xsl:variable name="times-per-day"><xsl:value-of select="times-per-day"/></xsl:variable>
																			<tr><td><font face="arial" style="font-size:8pt">
																						<DD><DL><tr><td><font face="arial" style="font-size:8pt">
																											<DT><I><xsl:text>You can cast  </xsl:text></I>
																												<b><xsl:value-of select="name"/></b>
																												<I><xsl:text> at a caster level of  </xsl:text></I>
																												<b><xsl:value-of select="caster-level"/></b>
																												<I><xsl:text>;  </xsl:text></I>
																												<b><xsl:value-of select="times-per-day"/></b>
																												<I><xsl:choose>
																														<xsl:when test="contains($times-per-day, 'At Will')">
																															<b><xsl:text>.</xsl:text></b>
																														</xsl:when>
																														<xsl:otherwise>
																															<xsl:text>  time(s) per day.</xsl:text>
																														</xsl:otherwise>
																													</xsl:choose></I></DT>
																											<font face="arial" style="font-size:8pt" color="#A0A0A0">
																												<DD><i><xsl:value-of select="document('ethdata.xml')/dnd/dbTable[@name='info Spell']/dbData/row[col[@nref='Name']=$name]/col[@nref='HelpText']"/></i></DD>
																											</font>
																										</font></td></tr></DL></DD>
																					</font></td></tr>
																		</xsl:for-each>
																	</font></td></tr></DL>
													</xsl:if>
												</font>
											</td></tr>
									</table>
								</td><td valign="top">
									<table>
										<tr><td style="border-bottom: 1pt solid black"><b>Class Features:</b></td></tr>
										<DL><tr><td>
													<font face="arial" style="font-size:8pt">
														<xsl:for-each select="features/class-features/class-feature">
															<DT/><b><i><u><xsl:value-of select="name"/></u>:</i></b><br/>
															<xsl:for-each select="feature">
																<xsl:sort select="." order="ascending"/>
																<xsl:variable name="featurename"><xsl:value-of select="."/></xsl:variable>
																<DD/><b><xsl:value-of select="."/>: </b>
																<xsl:value-of select="document('ethdata.xml')/dnd/dbTable[@name='info Features']/dbData/row[col[@nref='Name']=$featurename]/col[@nref='HelpText']"/><br/>
															</xsl:for-each><br/>
														</xsl:for-each>
													</font>
												</td></tr></DL>
									</table>
								</td></tr></table>
						<xsl:call-template name="biopage"/>
					</body>
				</html>
			</xsl:when>
			<xsl:otherwise>
				<html>
					<head><title>Error</title></head>
					<body text="#0000FF" bgcolor="#FFFFFF" link="#FF0000" alink="#FF00FF" vlink="#C0C0C0">
						<p align="center"><B><FONT SIZE="+3">Error</FONT></B><br/>You appear to either be running an old version of the dak180 Supplement Sheet or of eTools (<xsl:value-of select="/character/etools-version"/>).</p>
						<p align="center">You can check for a new version of eTools at <A HREF="http://www.codemonkeypublishing.com/">Code Monkey Publishing</A>.</p>
						<p align="center">For a new version of the dak180 Supplement Sheet check <A HREF="http://www.angelfire.com/dragon2/dak180/">The Home of dak180</A> under the D&amp;D section.</p>
					</body>
				</html>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="page-header">
		<xsl:param name="heading"></xsl:param>
		<table align="top" border="0" cellpadding="0" cellspacing="0" width="100%" bgcolor="white">
			<tr>
				<td width="20%" align="left" bgcolor="black">
					<font face="Verdana" style="font-size:9pt" color="white">
						<b><xsl:value-of select="/character/name"/></b>
					</font>
				</td>
				<td width="60%" align="center" bgcolor="black">
					<font face="Verdana" style="font-size:9pt" color="white">
						<b><xsl:value-of select="$heading"/></b>
					</font>
				</td>
				<td width="20%" align="center" bgcolor="black"><br/>
				</td>
			</tr>
		</table><br/>
	</xsl:template>
	<xsl:template name="biopage">
		<br style="page-break-after: always"/>
		<xsl:call-template name="page-header">
			<xsl:with-param name="heading">BIOGRAPHICAL INFORMATION</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="biodata"/></xsl:template>
</xsl:stylesheet>
